using System.Security.Cryptography.X509Certificates;

namespace AP_8_Adressage_IP_Alexis_Alagille
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }



        private void btn_calcul_Click(object sender, EventArgs e)
        {
            Global.ip = tb_saisie_ip.Text;
            string[] ip_parts = Global.ip.Split(".");

            byte ip_valide = 0;

            // Vrification de l'adresse IP //
            // Si l'adresse IP contient bien 4 octets //
            if (ip_parts.Length == 4)
            {
                for (int i = 0; i < 4; i++)
                {
                    // Si l'lment "i" du tableau est compris entre 0 et 255 //
                    if (int.Parse(ip_parts[i]) <= 255 && int.Parse(ip_parts[i]) >= 0)
                    {
                        ip_valide += 1;
                    }
                }

                if (ip_valide == 4)
                {

                    // Conversion en Adresse IP Binaire //

                    byte nbBase = 2;
                    string[] ip_binaire_part = { "", "", "", "" };

                    // Conversion de chaque octet en binaire sur 8 bits //
                    for (int i = 0; i < 4; i++)
                    {
                        int nb_ip = int.Parse(ip_parts[i]);
                        string nb_part_convert = Convert.ToString(nb_ip, nbBase).PadLeft(8, '0');
                        ip_binaire_part[i] = nb_part_convert;
                    }

                    // On reconstruit l'ip binaire  partir des 4 parties prsentent dans le tableau "ip_binaire_part"
                    string ip_binaire = String.Join(".", ip_binaire_part);

                    // Affichage de l'ip binaire dans la textbox : tb_ip_binaire //
                    tb_ip_binaire.Text = ip_binaire.ToString();

                    // Stockage des variables pour la seconde fentre //
                    Global.cidr = (byte)nup_saisie_cidr.Value;
                    Global.ip_binaire = tb_ip_binaire.Text;

                    // Lorsque tout est calculer : Activation du bouton pour aller  la suite //
                    tb_saisie_ip.Enabled = false;
                    nup_saisie_cidr.Enabled = false;
                    tb_ip_binaire.Enabled = false;
                    btn_calcul.Enabled = false;
                    btn_page_suivante.Enabled = true;
                }
                else
                {
                    // Message d'erreur : Taille d'un octet //
                    MessageBox.Show("Erreur de saisie de l'adressse IP : Un octet est compris entre 0 et 255 !");

                }
            }
            else
            {
                // Message d'erreur : Taille de l'adresse IP //
                MessageBox.Show("Erreur de saisie de l'adresse IP");
            }
        }



        private void btn_page_suivante_Click(object sender, EventArgs e)
        {
            // Affichage de la page "Traitements" //
            Traitements traitements = new Traitements();
            traitements.Show();
        }

        private void btn_quit_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void btn_nv_demande_Click(object sender, EventArgs e)
        {
            Global.ip = "";
            tb_saisie_ip.Text = Global.ip;
            nup_saisie_cidr.Value = 0;
            tb_ip_binaire.Text = "";

            tb_saisie_ip.Enabled = true;
            nup_saisie_cidr.Enabled = true;
            tb_ip_binaire.Enabled = true;
            btn_calcul.Enabled = true;
            btn_page_suivante.Enabled = false;
        }    
    }
}
